﻿using System;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for a particular hospital.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
    /// </history>
    public class HospitalViewModel
    {

        #region Properties

        /// <summary>
        /// Gets or sets the code system code of the hospital.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        public string CodeSystemCode { get; set; }

        /// <summary>
        /// Gets or sets the code of the hospital.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the name of the hospital.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="07 January 2014">Initial version.</change>
        /// </history>
        public string Name { get; set; }

        #endregion

    }

}